/*
 * Decompiled with CFR 0.152.
 */
package net.hecco.bountifulfares.block.custom;

import net.hecco.bountifulfares.block.BFBlocks;
import net.hecco.bountifulfares.block.entity.DyeableCeramicBlockEntity;
import net.hecco.bountifulfares.block.interfaces.DyeableCeramicBlockInterface;
import net.hecco.bountifulfares.item.BFItems;
import net.hecco.bountifulfares.sounds.BFSounds;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.AttachFace;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CeramicLeverBlock
extends LeverBlock
implements DyeableCeramicBlockInterface {
    public CeramicLeverBlock(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        ItemStack itemStack = player.m_21120_(hand);
        if (itemStack.m_150930_(BFItems.ARTISAN_BRUSH) && itemStack.m_41737_("display") != null) {
            int brushColor = itemStack.m_41737_("display").m_128451_("color");
            world.m_7471_(pos, false);
            world.m_46597_(pos, this.m_152465_(state));
            world.m_6263_(player, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_144133_, SoundSource.BLOCKS, 1.0f, 0.8f + world.f_46441_.m_188501_() / 3.0f);
            BlockEntity blockEntity = world.m_7702_(pos);
            if (blockEntity instanceof DyeableCeramicBlockEntity) {
                DyeableCeramicBlockEntity ceramicTilesBlockEntity = (DyeableCeramicBlockEntity)blockEntity;
                if (ceramicTilesBlockEntity.color != brushColor) {
                    ceramicTilesBlockEntity.color = brushColor;
                    ceramicTilesBlockEntity.m_6596_();
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (world.f_46443_) {
            BlockState blockState = (BlockState)state.m_61122_((Property)f_54622_);
            if (((Boolean)blockState.m_61143_((Property)f_54622_)).booleanValue()) {
                CeramicLeverBlock.spawnParticles(blockState, (LevelAccessor)world, pos, 1.0f);
            }
            return InteractionResult.SUCCESS;
        }
        BlockState blockState = this.m_54676_(state, world, pos);
        SoundEvent f = (Boolean)blockState.m_61143_((Property)f_54622_) != false ? BFSounds.CERAMIC_LEVER_ON : BFSounds.CERAMIC_LEVER_OFF;
        world.m_5594_(null, pos, f, SoundSource.BLOCKS, 0.8f, 1.0f);
        world.m_142346_((Entity)player, (Boolean)blockState.m_61143_((Property)f_54622_) != false ? GameEvent.f_223702_ : GameEvent.f_223703_, pos);
        return InteractionResult.CONSUME;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
        switch ((AttachFace)state.m_61143_((Property)f_53179_)) {
            case FLOOR: {
                return Block.m_49796_((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)2.0, (double)12.0);
            }
            case WALL: {
                switch ((Direction)state.m_61143_((Property)f_54117_)) {
                    case EAST: {
                        return Block.m_49796_((double)0.0, (double)4.0, (double)4.0, (double)2.0, (double)12.0, (double)12.0);
                    }
                    case WEST: {
                        return Block.m_49796_((double)14.0, (double)4.0, (double)4.0, (double)16.0, (double)12.0, (double)12.0);
                    }
                    case SOUTH: {
                        return Block.m_49796_((double)4.0, (double)4.0, (double)0.0, (double)12.0, (double)12.0, (double)2.0);
                    }
                }
                return Block.m_49796_((double)4.0, (double)4.0, (double)14.0, (double)12.0, (double)12.0, (double)16.0);
            }
        }
        return Block.m_49796_((double)4.0, (double)14.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);
    }

    private static void spawnParticles(BlockState state, LevelAccessor world, BlockPos pos, float alpha) {
        Direction direction = ((Direction)state.m_61143_((Property)f_54117_)).m_122424_();
        Direction direction2 = CeramicLeverBlock.m_53200_((BlockState)state).m_122424_();
        double d = (double)pos.m_123341_() + 0.5 + 0.1 * (double)direction.m_122429_() + 0.2 * (double)direction2.m_122429_();
        double e = (double)pos.m_123342_() + 0.5 + 0.1 * (double)direction.m_122430_() + 0.2 * (double)direction2.m_122430_();
        double f = (double)pos.m_123343_() + 0.5 + 0.1 * (double)direction.m_122431_() + 0.2 * (double)direction2.m_122431_();
        world.m_7106_((ParticleOptions)new DustParticleOptions(DustParticleOptions.f_175788_, alpha), d, e, f, 0.0, 0.0, 0.0);
    }

    public ItemStack m_7397_(BlockGetter world, BlockPos pos, BlockState state) {
        if (DyeableCeramicBlockEntity.getColor(world, pos) != 0xFFFFFF) {
            ItemStack stack = super.m_7397_(world, pos, state);
            return this.pickBlock(world, pos, stack);
        }
        return new ItemStack((ItemLike)BFBlocks.CERAMIC_LEVER);
    }
}

